#include <windows.h>
#include "typedef.h"
//#include "Command.h"
#include "string.h"
//#include "Delay.h"
#include "CRC16.h"
#include "usbprint.h"
#include <stdlib.H>
#include <devguid.h>
#include <initguid.h>
#include "LibUSB3DPrinter.h"
//================================================
#define STATUS_IDLE 0
#define STATUS_BUSY 1
//-------------------------
#define PARA_SET 0
#define PARA_GET 1
//-------------------------
//command id
#define CMD_STATUS			0x00
#define CMD_CURRENT				0x01   
#define CMD_LED_SWITCH          0x02//LED   
#define CMD_FLIP				0x09//ͼת   
#define CTL_IMAGE_DISPXY_00     0x01
#define CTL_IMAGE_DISPXY_10     0x02
#define CTL_IMAGE_DISPXY_01     0x03
#define CTL_IMAGE_DISPXY_11     0x04


#define CMD_POWER_ON_OFF    0x03
#define CTL_POWER_ON            0x01
#define CTL_POWER_OFF           0x02

#define CMD_SYSTEM_SATUS        0xf6
#define CMD_PRODUCT_ID_SET      0xf7
#define CMD_PRODUCT_ID_READ     0xf8
//****************************************************************

unsigned char PackageTransmit(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	//unsigned char buffer[1028];
	unsigned char *buffer;
	unsigned short crc16;
	unsigned int i,nBytes;

	if(Buffer==NULL)
		return 0;

	buffer=(unsigned char *) malloc (Size+4);

	if(buffer==NULL)
		return 0;

	buffer[0]=(Size+4)&0xff;
	buffer[1]=((Size+4)>>8)&0xff;
	for(i=0;i<Size;i++)
	{
		buffer[2+i]=Buffer[i];
	}
	crc16=CRC16(buffer,Size+2);
	buffer[Size+2]=(crc16>>8)&0xff;
	buffer[Size+3]=crc16&0xff;
	nBytes=WriteBytes(buffer,Size+4,TimeOut);
	if(nBytes==(Size+4))
	{
		free (buffer);
		return 1;
	}
	free (buffer);
	return 0;
}

unsigned char PackageReceive(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	//unsigned char buffer[1028];
	unsigned int nBytes=0;
	unsigned int i,Cnt;
	unsigned short crc16;
	unsigned char   *buffer;

	if(Buffer==NULL)
		return 0;
    buffer=(unsigned char *) malloc (Size+4);

	if(buffer==NULL)
		return 0;
    
	nBytes=ReadBytes(buffer,Size+4,TimeOut);
	if(nBytes!=(Size+4))
	{
		free (buffer);
		return 0;
	}
	Cnt=(buffer[1]<<8)|buffer[0];
	if(Cnt !=nBytes)
	{
		free (buffer);
		return 0;
	}

	crc16=CRC16(buffer,Size+2);

    if(CRC16(buffer,Size+4))
	{
		free (buffer);
		return 0;
	}
    for(i=0;i<Size;i++)
		Buffer[i]=buffer[2+i];
	free (buffer);
	return 1;
}

static Bool Command(U8 cmd,U8 *TransmitBuffer,U32 TransmitSize,U8 *ReceiveBuffer,U32 ReceiveSize,U32 TimeOut)
{
	U32 i;
	unsigned char *buffer;

	if(TransmitBuffer==NULL && TransmitSize>0)
		return FALSE;
		
    buffer=(unsigned char *) malloc (TransmitSize+4);

	if(buffer==NULL)
		return FALSE;

    buffer[0]=cmd;

	for(i=0;i<TransmitSize;i++)
	{
		buffer[i+1]=TransmitBuffer[i];
	}

	if(PackageTransmit(buffer,TransmitSize+1,TimeOut)==0)
	{
		return FALSE;
	}

	if(ReceiveSize==0)
		return TRUE;

	if(ReceiveBuffer==NULL)
		return FALSE;

	if(PackageReceive(ReceiveBuffer,ReceiveSize,TimeOut))
	{
		return TRUE;
	}

	return FALSE;
}


LIBUSB3DPRINTER_API unsigned char GetStatus(void)
{
	unsigned char buffer[10];
	unsigned char Value;
	buffer[0]=CMD_STATUS;
	PackageTransmit(buffer,1,1000);
	PackageReceive(&Value,1,1000);
	return Value;
}


LIBUSB3DPRINTER_API Bool LedOnOff(unsigned char flag)
{
    U8 buffer[6];
	
	buffer[0]=flag;

	if(Command(CMD_LED_SWITCH,buffer,1,NULL,0,50)==FALSE)
		return FALSE;
	return TRUE;
}



LIBUSB3DPRINTER_API Bool GetCurrent(U8 *Value)
{
	U8 buffer[50];
	buffer[0]=PARA_GET;
	if(Command(CMD_CURRENT,buffer,1,buffer,1,50)==FALSE)
	{
		*Value=0;
		return FALSE;
	}
	*Value=buffer[0];
	return TRUE;
}


LIBUSB3DPRINTER_API Bool SetCurrent(U8 Value)
{
	U8 buffer[7];
	buffer[0]=PARA_SET;
	buffer[1]=Value;
	
	if(Command(CMD_CURRENT,buffer,2,NULL,0,100)==FALSE)
		return FALSE;
	return TRUE;
}

//==============================================================
LIBUSB3DPRINTER_API Bool Flip(unsigned char FlipX,unsigned char FlipY)
{
	U8 buffer[3],Value=0x01;

	if(FlipX==0 && FlipY==0)
		Value=CTL_IMAGE_DISPXY_00;
	if(FlipX==1 && FlipY==0)
		Value=CTL_IMAGE_DISPXY_10;
	if(FlipX==0 && FlipY==1)
		Value=CTL_IMAGE_DISPXY_01;
	if(FlipX==1 && FlipY==1)
		Value=CTL_IMAGE_DISPXY_11;

	buffer[0]=PARA_SET;
	buffer[1]=Value;
	if(Command(CMD_FLIP,buffer,2,NULL,0,50)==FALSE)
		return FALSE;
	return TRUE;
}

LIBUSB3DPRINTER_API unsigned char  GetProductID(unsigned char *pID)
{
    unsigned char buffer[8];
    if(pID==NULL)
        return FALSE;
    //size =id (6byte) + date (2byte)
    buffer[0]=CMD_PRODUCT_ID_READ;
    PackageTransmit(buffer,2,1000);
    PackageReceive(pID,8,1000);
    //ID0  = buffer[0]; //ID:(6byte)
    //ID1  = buffer[1];
    //ID2  = buffer[2];
    //ID3  = buffer[3];
    //ID4  = buffer[4];
    //ID5  = buffer[5];
    //ID6  = buffer[6]; //yy/ww(2byte)
    //ID7  = buffer[7] %12;
    pID[7] = pID[7] %12;
    return TRUE;
}

LIBUSB3DPRINTER_API unsigned char GetSysStatus(void)
{
    unsigned char buffer[5];
    unsigned char Value;
    buffer[0]=CMD_SYSTEM_SATUS;
    PackageTransmit(buffer,1,1000);
    PackageReceive(&Value,1,1000);
    return Value;
}

LIBUSB3DPRINTER_API unsigned char PowerOnOff(unsigned char flag)
{
    unsigned char buffer[5];
    buffer[0]=CMD_POWER_ON_OFF;
	if(flag)
		buffer[1]=CTL_POWER_ON;
	else
		buffer[1]=CTL_POWER_OFF;
    PackageTransmit(buffer,2,1000);
	return TRUE;
}
//--------------------------------------------------------------------------

#define CMD_RUN_BOOT      0xf9
#define CMD_BUFFER_SIZE	  0xfa
#define CMD_WRITE         0xfb
#define CMD_READ          0xfc
#define CMD_RUN_APP       0xfd
#define CMD_MAGIC         0xfe

LIBUSB3DPRINTER_API unsigned int GetBlockSize(void)
{
    unsigned char buffer[10];
    unsigned int Size=0;
    buffer[0]=CMD_BUFFER_SIZE;
    PackageTransmit(buffer,1,1000);
    PackageReceive((unsigned char*)&Size,4,1000);
    return Size;
    //return 512;
}

LIBUSB3DPRINTER_API BOOLEAN ispWrite(unsigned long Address,unsigned long Size,unsigned char *Data)
{
    unsigned char   *buffer;
    unsigned char *RevBuf;
    if(Data==NULL)
        return FALSE;
    buffer =(unsigned char *) malloc (Size+9);
    RevBuf =(unsigned char *) malloc (Size+9);
    if(buffer==NULL || RevBuf==NULL)
    {
        return FALSE;
    }
    //Command
    buffer[0]=CMD_WRITE;
    //Address 4 Bytes low first
    buffer[1]=(unsigned char)((Address>>0)&0xff);
    buffer[2]=(unsigned char)((Address>>8)&0xff);
    buffer[3]=(unsigned char)((Address>>16)&0xff);
    buffer[4]=(unsigned char)((Address>>24)&0xff);
    //Data len 4 Byte low first
    buffer[5]=(unsigned char)((Size>>0)&0xff);
    buffer[6]=(unsigned char)((Size>>8)&0xff);
    buffer[7]=(unsigned char)((Size>>16)&0xff);
    buffer[8]=(unsigned char)((Size>>24)&0xff);
    memcpy(buffer+9,Data,Size);
    memcpy(RevBuf,buffer,9);

    if(PackageTransmit(buffer,Size+9,2000)==0)
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }
    Delay1Ms(40);
    //----------------------------------------------------------
    RevBuf[0]=CMD_READ;
    if (PackageTransmit(RevBuf,9,2000)==0)
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }

    if(PackageReceive(RevBuf+9,Size,2000)==0)
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }
    if(memcmp(RevBuf+9,buffer+9,Size))
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }
    free (buffer);
    free (RevBuf);
  return TRUE;
}

LIBUSB3DPRINTER_API BOOLEAN ispRead(unsigned long Address,unsigned long Size,unsigned char *Data)
{
    //unsigned char   buffer[10];
    unsigned char   *buffer;
    if(Data==NULL)
        return FALSE;
    buffer =(unsigned char *) malloc (Size+9);
    if(buffer==NULL)
        return FALSE;
    //unsigned long nBytesWritten,nBytesRead;
    //Command
    buffer[0]=CMD_READ;
    //Address 4 Bytes low first
    buffer[1]=(unsigned char)((Address>>0)&0xff);
    buffer[2]=(unsigned char)((Address>>8)&0xff);
    buffer[3]=(unsigned char)((Address>>16)&0xff);
    buffer[4]=(unsigned char)((Address>>24)&0xff);
    //Data len 4 Byte low first
    buffer[5]=(unsigned char)((Size>>0)&0xff);
    buffer[6]=(unsigned char)((Size>>8)&0xff);
    buffer[7]=(unsigned char)((Size>>16)&0xff);
    buffer[8]=(unsigned char)((Size>>24)&0xff);

    if (PackageTransmit(buffer,9,2000)==0)
    {
        free (buffer);
        return FALSE;
    }

    if(PackageReceive(Data,Size,2000)==0)
    {
        free (buffer);
        return FALSE;
    }
    free (buffer);
    Delay1Ms(100);
    return TRUE;
}

LIBUSB3DPRINTER_API BOOLEAN ispRunBoot(void)
{
    unsigned char buffer[10];
    buffer[0]=CMD_RUN_BOOT;
    return PackageTransmit(buffer,1,2000);
}

LIBUSB3DPRINTER_API BOOLEAN ispRunApp(void)
{
    unsigned char buffer[10];
    buffer[0]=CMD_RUN_APP;
    return PackageTransmit(buffer,1,2000);
}

LIBUSB3DPRINTER_API void ispMagic(unsigned char *Magic)
{
    unsigned char buffer[10];
    buffer[0]=CMD_MAGIC;
    PackageTransmit(buffer,1,1000);
    PackageReceive(Magic,3,1000);
    return ;
}
//=================================================================================








