
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the LIBUSB3DPRINTER_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// LIBUSB3DPRINTER_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifndef __LIBUSB3DPRINTER_H__
#define __LIBUSB3DPRINTER_H__
#ifdef LIBUSB3DPRINTER_EXPORTS
#define LIBUSB3DPRINTER_API __declspec(dllexport)
#else
#define LIBUSB3DPRINTER_API __declspec(dllimport)
#pragma comment(lib,"Library\\dll\\LibUSB3DPrinter.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define USB_VID 0xC251
#define USB_PID 0x1706
#define USB_DEV_SERIAL_NO  "0002a0000000"

LIBUSB3DPRINTER_API void Delay10Ms(U16 m10s);
LIBUSB3DPRINTER_API void Delay1Ms(U16 ms);

LIBUSB3DPRINTER_API unsigned char GetStatus(void);
LIBUSB3DPRINTER_API Bool LedOnOff(unsigned char flag);
LIBUSB3DPRINTER_API Bool GetCurrent(U8 *Value);
LIBUSB3DPRINTER_API Bool SetCurrent(U8 Value);
LIBUSB3DPRINTER_API Bool Flip(unsigned char FlipX,unsigned char FlipY);
LIBUSB3DPRINTER_API unsigned char  GetProductID(unsigned char *pID);
LIBUSB3DPRINTER_API unsigned char GetSysStatus(void);
LIBUSB3DPRINTER_API unsigned char PowerOnOff(unsigned char flag);
//--------------------------------------------------------------------------
LIBUSB3DPRINTER_API unsigned int GetBlockSize(void);
LIBUSB3DPRINTER_API BOOLEAN ispWrite(unsigned long Address,unsigned long Size,unsigned char *Data);
LIBUSB3DPRINTER_API BOOLEAN ispRead(unsigned long Address,unsigned long Size,unsigned char *Data);
LIBUSB3DPRINTER_API BOOLEAN ispRunBoot(void);
LIBUSB3DPRINTER_API BOOLEAN ispRunApp(void);
LIBUSB3DPRINTER_API void ispMagic(unsigned char *Magic);

LIBUSB3DPRINTER_API unsigned char OpenUsbDevice(void);
LIBUSB3DPRINTER_API unsigned char CheckUsbVidPid(char *DevicePath,int vendorID,int productID);


#ifdef __cplusplus
}
#endif

#endif